/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.util;

import common.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import common.com.cursee.more_bows_and_arrows.core.util.FireworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class PaperEffectsUtil {
    public static void randomEntityEffects(Player attacker, LivingEntity defender) {
        switch (attacker.getRandom().nextInt(1, 8)) {
            case 1: {
                CommonEffectsUtil.lightingCausedByPlayer(attacker, defender.blockPosition());
                break;
            }
            case 2: {
                defender.setRemainingFireTicks(40);
                break;
            }
            case 3: {
                defender.teleportTo(attacker.xo, attacker.yo, attacker.zo);
                break;
            }
            case 4: {
                attacker.teleportTo(defender.xo, defender.yo, defender.zo);
                break;
            }
            case 5: {
                defender.teleportTo(defender.xo, defender.yo + 10.0, defender.zo);
                break;
            }
            case 6: {
                attacker.level().explode((Entity)attacker, defender.xo, defender.yo, defender.zo, 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 7: {
                for (int i = 1; i < 4; ++i) {
                    Chicken createdChicken = (Chicken)EntityType.CHICKEN.create(attacker.level());
                    if (createdChicken == null) {
                        return;
                    }
                    if (attacker.getRandom().nextFloat() < 0.05f) {
                        if (attacker.getRandom().nextBoolean()) {
                            createdChicken.setCustomName((Component)Component.literal((String)"Dinnerbone"));
                        } else {
                            createdChicken.setCustomName((Component)Component.literal((String)"Grumm"));
                        }
                    }
                    createdChicken.moveTo(defender.xo, defender.yo + (double)i, defender.zo);
                }
                break;
            }
            case 8: {
                for (int i = 1; i < 4; ++i) {
                    Zombie createdZombie = (Zombie)EntityType.ZOMBIE.create(attacker.level());
                    if (createdZombie == null) {
                        return;
                    }
                    if (attacker.getRandom().nextFloat() < 0.05f) {
                        if (attacker.getRandom().nextBoolean()) {
                            createdZombie.setCustomName((Component)Component.literal((String)"Dinnerbone"));
                        } else {
                            createdZombie.setCustomName((Component)Component.literal((String)"Grumm"));
                        }
                    }
                    createdZombie.moveTo(defender.xo, defender.yo, defender.zo);
                }
                break;
            }
        }
    }

    public static void randomBlockEffects(Player player, BlockHitResult blockHitResult) {
        BlockPos blockPos = blockHitResult.getBlockPos();
        switch (player.getRandom().nextInt(1, 8)) {
            case 1: {
                player.level().explode((Entity)player, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 2.0f, true, Level.ExplosionInteraction.TNT);
                break;
            }
            case 2: {
                player.teleportTo((double)blockPos.getX(), (double)(blockPos.getY() + 10), (double)blockPos.getZ());
                break;
            }
            case 3: {
                player.teleportTo(player.xo, player.yo + 10.0, player.zo);
                break;
            }
            case 4: {
                player.teleportTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                break;
            }
            case 5: {
                CommonEffectsUtil.lightingCausedByPlayer(player, blockPos);
                break;
            }
            case 6: {
                FireworkUtil.createRandomFireworkFromEntity((LivingEntity)player, blockHitResult.getBlockPos());
                break;
            }
            case 7: {
                for (int i = 1; i < 4; ++i) {
                    Chicken createdChicken = (Chicken)EntityType.CHICKEN.create(player.level());
                    if (createdChicken == null) {
                        return;
                    }
                    if (player.getRandom().nextFloat() < 0.05f) {
                        if (player.getRandom().nextBoolean()) {
                            createdChicken.setCustomName((Component)Component.literal((String)"Dinnerbone"));
                        } else {
                            createdChicken.setCustomName((Component)Component.literal((String)"Grumm"));
                        }
                    }
                    createdChicken.moveTo((double)blockHitResult.getBlockPos().getX(), (double)(blockHitResult.getBlockPos().getY() + i), (double)blockHitResult.getBlockPos().getZ());
                }
                break;
            }
            case 8: {
                for (int i = 1; i < 4; ++i) {
                    Zombie createdZombie = (Zombie)EntityType.ZOMBIE.create(player.level());
                    if (createdZombie == null) {
                        return;
                    }
                    if (player.getRandom().nextFloat() < 0.05f) {
                        if (player.getRandom().nextBoolean()) {
                            createdZombie.setCustomName((Component)Component.literal((String)"Dinnerbone"));
                        } else {
                            createdZombie.setCustomName((Component)Component.literal((String)"Grumm"));
                        }
                    }
                    createdZombie.moveTo((double)blockHitResult.getBlockPos().getX(), (double)blockHitResult.getBlockPos().getY(), (double)blockHitResult.getBlockPos().getZ());
                }
                break;
            }
        }
    }
}

